#include <bits/stdc++.h>

using namespace std;

const int mxN = 5005;
vector<int> adj[mxN];

void solve() {
    int n, k;
    cin >> n >> k;

    for(int i = 0; i < n; ++i) {
        adj[i].clear();
    }

    for(int i = 1; i < n; ++i) {
        int u, v;
        cin >> u >> v;
        --u, --v;
        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    const int INF = 1e9 + 12;

    auto nadji = [&](int s) {
        vector<int> dist(n, INF);
        queue<int> q;

        dist[s] = 0;
        q.push(s);

        while(!q.empty()) {
            auto tren = q.front();
            q.pop();

            for(auto e : adj[tren]) {
                if(dist[e] > dist[tren] + 1) {
                    dist[e] = dist[tren] + 1;
                    q.push(e);
                }
            }
        }

        return max_element(dist.begin(), dist.end()) - dist.begin();
    };

    int root = nadji(0);
    vector<int> rod(n, -1);
    vector<int> dep(n);

    auto dfs = [&](auto &self, int s, int p) -> void {
        rod[s] = p;

        if(p != -1) {
            dep[s] = dep[p] + 1;
        }

        for(auto e : adj[s]) {
            if(e == p) continue;
            self(self, e, s);
        }
    };

    dfs(dfs, root, -1);

    vector<bool> marked(n, false);

    int ans = -1;

    {
        int naj = max_element(dep.begin(), dep.end()) - dep.begin();
        ans = dep[naj];

        while(naj != -1) {
            marked[naj] = true;
            naj = rod[naj];
        }
    }

    for(int iter = 0; iter < k; ++iter) {
        vector<int> redosled;
        redosled.reserve(n);
        for(int i = 0; i < n; ++i) {
            if(marked[i]) continue;
            redosled.push_back(i);
        }

        if(redosled.empty()) break;

        sort(redosled.begin(), redosled.end(), [&](int a, int b) {
            return dep[a] < dep[b];
        });

        vector<bool> vis(n);
        vector<pair<int, int>> raz(n, {-1, -1});

        auto dfs2 = [&](auto &self, int s, int p) -> void {
            if(marked[s]) return;
            if(vis[s]) return;

            vis[s] = true;

            raz[s] = {0, s};

            for(auto e : adj[s]) {
                if(e == p) continue;
                self(self, e, s);

                auto temp = raz[s];
                if(temp.first == -1) continue;
                ++temp.first;
                
                raz[s] = max(raz[s], temp);
            }
        };

        for(auto z : redosled) {
            if(!vis[z]) {
                dfs2(dfs2, z, -1);
            }
        }

        auto najbolji = *max_element(raz.begin(), raz.end());

        while(najbolji.second != -1 && !marked[najbolji.second]) {
            marked[najbolji.second] = true;
            ++ans;
            najbolji.second = rod[najbolji.second];
        }
    }

    cout << ans << '\n';
}

int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);

    int t;
    cin >> t;
    while(t--) solve();
}